package newstate.test;

import newstate.*;
import newstate.tools.*;
import java.util.*;

class TCPTest
{      
        public static FSM createTCPFSM()
        {
                FSM fsm = new FSM();
                fsm.addState("Closed");
                fsm.addState("Listen");
                fsm.addState("SYN Received");
                fsm.addState("SYN Sent");
                fsm.addState("Established");
                fsm.addState("FIN Wait (1)");
                fsm.addState("FIN Wait (2)");
                fsm.addState("Closing");
                fsm.addState("Close Wait");
                fsm.addState("Last ACK");
                fsm.addState("Time Wait");

                fsm.addEvent("Passive open");
                fsm.addEvent("Active open");
                fsm.addEvent("Close");
                fsm.addEvent("Send");
                fsm.addEvent("Received ACK of SYN");
                fsm.addEvent("Receive ACK of FIN");
                fsm.addEvent("Receive SYN, ACK");
                fsm.addEvent("Receive FIN"); 
                fsm.addEvent("Receive SYN"); 
                fsm.addEvent("Timeout (2ms)");
                

                fsm.addTransition("Closed", "Passive open", "Listen", new WriteLogAction("create TCB"));
                fsm.addTransition("Listen", "Close", "Closed", new WriteLogAction("delete TCB"));
                fsm.addTransition("Closed", "Active open", "SYN Sent", new WriteLogAction("create TCB\nsend SYN"));
                fsm.addTransition("SYN Sent", "Close", "Closed", new WriteLogAction("delete TCB"));
                fsm.addTransition("Listen", "Receive SYN", "SYN Received", new WriteLogAction("sent SYN, ACK"));
                fsm.addTransition("Listen", "Send", "SYN Sent", new WriteLogAction("send SYN"));
                fsm.addTransition("SYN Sent", "Receive SYN", "SYN Received", new WriteLogAction("send ACK"));
                fsm.addTransition("SYN Sent", "Receive SYN, ACK", "Established", new WriteLogAction("send ACK"));
                fsm.addTransition("SYN Received", "Received ACK of SYN", "Established", new WriteLogAction("do nothing"));
                fsm.addTransition("SYN Received", "Close", "FIN Wait (1)", new WriteLogAction("Send FIN"));
                fsm.addTransition("Established", "Close", "FIN Wait (1)", new WriteLogAction("send FIN"));
                fsm.addTransition("Established", "Receive FIN", "Close Wait", new WriteLogAction("send ACK"));
                fsm.addTransition("FIN Wait (1)", "Receive ACK of FIN", "FIN Wait (2)", new WriteLogAction("do nothing"));
                fsm.addTransition("FIN Wait (1)", "Receive FIN", "Closing", new WriteLogAction("send ACK"));
                fsm.addTransition("FIN Wait (2)", "Receive FIN", "Time Wait", new WriteLogAction("Send ACK"));
                fsm.addTransition("Closing", "Receive ACK of FIN", "Time Wait", new WriteLogAction("do nothing"));
                fsm.addTransition("Time Wait", "Timeout (2ms)", "Closed", new WriteLogAction("delete TCB"));                
                fsm.addTransition("Close Wait", "Close", "Last ACK", new WriteLogAction("Send FIN"));                
                fsm.addTransition("Last ACK", "Receive ACK of FIN", "Closed", new WriteLogAction("do nothing"));                

                fsm.setFirstState("Closed");
                
                return fsm;
        }
        
        public static void main(String ps[])
        {
                FSM fsm = createTCPFSM();

                new FSMController(fsm.createFSMInstance()).show();
                new FSMController(fsm.createFSMInstance()).show();
                new FSMController(fsm.createFSMInstance()).show();
       }       
}